/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.udp.ethernet;

import com.gprinter.udp.UdpCommand;
import com.gprinter.utils.NetworkUtils;

public class SettingMacCommand
extends UdpCommand {
    private byte[] mac = new byte[6];
    private boolean valid = false;

    public SettingMacCommand(String mac) {
        this.valid = NetworkUtils.getMac(mac, this.mac);
    }

    public SettingMacCommand(byte[] mac) {
        if (mac != null && mac.length >= 6) {
            System.arraycopy(mac, 0, this.mac, 0, 6);
            this.valid = true;
        } else {
            this.valid = false;
        }
    }

    @Override
    public byte[] getCommand() {
        if (this.valid) {
            byte[] data = new byte[13];
            data[0] = 31;
            data[1] = 27;
            data[2] = 31;
            data[3] = -111;
            data[4] = 0;
            data[5] = 73;
            data[6] = 68;
            System.arraycopy(this.mac, 0, data, 7, 6);
            return data;
        }
        return null;
    }
}

